/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingFault;
import javax.wsdl.extensions.soap.SOAPFault;

public class WSBindingFault {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSBindingFault";
    private WSDefinition m_definition = null;
    private BindingFault m_bindingFault = null;
    private SOAPFault[] m_soapFaults = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                this.m_definition = null;
                this.m_bindingFault = null;
                if (this.m_soapFaults != null) {
                    SOAPFault[] soapFaults = this.m_soapFaults;
                    this.m_soapFaults = null;
                    for (int i = 0; i < soapFaults.length; ++i) {
                        soapFaults[i] = null;
                    }
                    soapFaults = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSBindingFault(WSDefinition definition, BindingFault bindingFault) {
        this.m_definition = definition;
        this.m_bindingFault = bindingFault;
        if (bindingFault != null) {
            this.initExtensiveElements(bindingFault.getExtensibilityElements());
        }
    }

    protected void initExtensiveElements(List l) {
        if (l != null && l.size() > 0) {
            Vector<SOAPFault> faults = new Vector<SOAPFault>();
            Iterator it = l.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj == null || !(obj instanceof SOAPFault)) continue;
                    faults.add((SOAPFault)obj);
                }
            }
            if (faults != null && faults.size() > 0) {
                this.m_soapFaults = new SOAPFault[faults.size()];
                faults.toArray(this.m_soapFaults);
                faults.removeAllElements();
            }
        }
    }

    public String getName() {
        if (this.m_bindingFault != null) {
            return this.m_bindingFault.getName();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_bindingFault != null) {
            return this.m_bindingFault.getName();
        }
        return null;
    }

    public BindingFault getBindingFault() {
        return this.m_bindingFault;
    }

    public String toString() {
        if (this.m_bindingFault != null) {
            return this.m_bindingFault.toString();
        }
        return null;
    }

    public SOAPFault[] getSoapFaults() {
        return this.m_soapFaults;
    }
}

